-----------------------------------------------------------------------------------------------
-- radius_search_example.sql <from_5-Digit_ZIP_Code> <within_distance> <state_code>
--
-- Example SQL Query for doing a radius search against an ADDRESS compared to a stationary location
--
-- History:
--   3/16/2007     Created
--   8/6/2007      Added join to ps_personal_data; added input parameters instead of hard coded parameters
--
-- Copyright (c) 2007 Runner Technologies, Inc.  All Rights Reserved.
-- www.RunnerTechnologies.com   sales@RunnerTechnologies.com   877-784-0003  561-395-9322
-----------------------------------------------------------------------------------------------
-- Customer has the right to modify this script so long as original copyright remains
-----------------------------------------------------------------------------------------------

select distinct
       a.address_line_1  "Line1"
      ,a.address_line_2 "Line2"
      ,a.address_line_3 "Line3"
      ,a.city           "City"
      ,a.state          "State"
      ,a.postal_code    "ZIP"
      ,dest.latitude          "Lat"
      ,-1*abs(dest.longitude) "Long"
      ,round(CLEAN_Address.Get_Distance(
                        src.latitude
                       ,-1*abs(src.longitude)
                       ,dest.latitude
                       ,-1*abs(dest.longitude)
                       ),2)   "Miles"
      ,CLEAN_Address.Get_Directional(CLEAN_Address.Get_Bearing(
                        src.latitude
                       ,-1*abs(src.longitude)
                       ,dest.latitude
                       ,-1*abs(dest.longitude)
                       ))     "Direction"
from  CLN_ADDRESSES a
     ,cln_postal_codes src
     ,cln_postal_codes dest
where src.postal_code = substr('&ZIP_Code',1,5)  -- Stationary Location
and   src.country_code='US'
and   substr(a.postal_code,1,5) = dest.postal_code
and   dest.country_code='US'
and   a.state = upper('&State')
and   CLEAN_Address.Get_Distance(src.latitude
                                ,-1*abs(src.longitude)
                                ,dest.latitude
                                ,-1*abs(dest.longitude)
                                ) <= &Distance  -- Within this many miles
order by "Miles"
